﻿#pragma once
#include "AppWindow.h"

namespace RTCam {

class RTCore final
{
public:
	RTCore();
	~RTCore();

	HRESULT Initialize(_In_ HINSTANCE hInstance, int nCmdShow);
	
	// Physics update
	void FixedUpdate();
	
	// RenderUpdate then Render
	void Render();

	void OnResize();

	// TODO: Refactor into an input manager.
	void OnKeyUp(UINT keyCode);
	// END TODO



private:
	bool m_initialized;

	shared_ptr<class AppWindow> m_window;
	shared_ptr<class Scene> m_scene;
	shared_ptr<class ResourceManager> m_resources;

	unique_ptr<class BasicTimer> m_updateTimer;
	unique_ptr<class BasicTimer> m_renderTimer;
	unique_ptr<class FpsTimer> m_updateFpsTimer;
	unique_ptr<class FpsTimer> m_renderFpsTimer;
	unique_ptr<class RTRenderer> m_renderer;
	unique_ptr<class RTSimulation> m_simulation;
	unique_ptr<class SceneImporter> m_sceneImporter;
	unique_ptr<class LensImporter> m_lensImporter;
	
};

}